<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Event', function(Blueprint $table) {
			$table->foreign('organisation_id')->references('id')->on('Organisation')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Shop', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Buy', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Buy', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Buy', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('Event')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Credit', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Organisation', function(Blueprint $table) {
			$table->foreign('organised_event')->references('id')->on('Event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Event', function(Blueprint $table) {
			$table->dropForeign('Event_organisation_id_foreign');
		});
		Schema::table('Shop', function(Blueprint $table) {
			$table->dropForeign('Shop_user_id_foreign');
		});
		Schema::table('Buy', function(Blueprint $table) {
			$table->dropForeign('Buy_product_id_foreign');
		});
		Schema::table('Buy', function(Blueprint $table) {
			$table->dropForeign('Buy_user_id_foreign');
		});
		Schema::table('Buy', function(Blueprint $table) {
			$table->dropForeign('Buy_event_id_foreign');
		});
		Schema::table('Credit', function(Blueprint $table) {
			$table->dropForeign('Credit_user_id_foreign');
		});
		Schema::table('Organisation', function(Blueprint $table) {
			$table->dropForeign('Organisation_organised_event_foreign');
		});
	}
}