<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organization')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('billboards', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organization')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign', function(Blueprint $table) {
			$table->foreign('org_id')->references('id')->on('organization')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('billboard_campaign', function(Blueprint $table) {
			$table->foreign('billboard_id')->references('id')->on('billboards')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('billboard_campaign', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaign')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_org_id_foreign');
		});
		Schema::table('billboards', function(Blueprint $table) {
			$table->dropForeign('billboards_org_id_foreign');
		});
		Schema::table('campaign', function(Blueprint $table) {
			$table->dropForeign('campaign_org_id_foreign');
		});
		Schema::table('billboard_campaign', function(Blueprint $table) {
			$table->dropForeign('billboard_campaign_billboard_id_foreign');
		});
		Schema::table('billboard_campaign', function(Blueprint $table) {
			$table->dropForeign('billboard_campaign_campaign_id_foreign');
		});
	}
}