<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchaseLinesTable extends Migration {

	public function up()
	{
		Schema::create('purchase_lines', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->integer('product_id')->unsigned();
			$table->bigInteger('purchaserequest_id')->unsigned();
			$table->decimal('qty', 10,5)->default('0');
			$table->decimal('price', 18,2)->default('0');
			$table->decimal('amount', 18,2)->default('0');
			$table->boolean('added_to_pr')->default(false);
			$table->integer('created_by')->default('0');
			$table->integer('updated_by')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('purchase_lines');
	}
}