<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePreOrdersTable extends Migration {

	public function up()
	{
		Schema::create('pre_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned()->default('0');
			$table->decimal('qty', 10,2)->default('0');
			$table->integer('created_by')->default('0');
			$table->integer('updated_by')->default('0');
			$table->timestamps();
			$table->boolean('added_to_pr')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('pre_orders');
	}
}