<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CartItem extends Eloquent {

	protected $table = 'cart_lines';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('qty', 'price', 'amount', 'discount', 'total_amount', 'grand_total', 'updated_by');

	public function product()
	{
		return $this->belongsTo('Product', 'katalog_id', 'id');
	}

}