<?php

namespace App\Models\Order;

class CashierLine extends Eloquent {

	protected $table = 'cashier_lines';
	public $timestamps = true;
	protected $fillable = array('price', 'amount', 'discount', 'total_amount', 'qty_return', 'amount_return', 'grand_total', 'created_by', 'updated_by');

	public function cashier()
	{
		return $this->belongsTo('Cashier', 'cashier_id', 'id');
	}

	public function product()
	{
		return $this->belongsTo('Product', 'product_id', 'id');
	}

}