<?php

namespace App\Models\Data;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('position', 'purchase_price', 'margin', 'selling_price', 'stock', 'unit_quantity', 'min_quantity', 'quantity_increment', 'sku', 'gtin', 'mpn', 'ean', 'length_value', 'width_value', 'height_value', 'volume_value', 'length_unit', 'width_unit', 'height_unit', 'weight_unit', 'volume_unit', 'description', 'updated_by');

	public function cartitem()
	{
		return $this->hasMany('CartItem');
	}

	public function orderitem()
	{
		return $this->hasMany('OrderItem');
	}

	public function stock()
	{
		return $this->hasMany('Stock');
	}

	public function preorder()
	{
		return $this->hasMany('PreOrder');
	}

	public function cashierline()
	{
		return $this->hasMany('CashierLine');
	}

	public function media()
	{
		return $this->hasMany('Media');
	}

	public function productcollection()
	{
		return $this->belongsTo('ProductCollection', 'product_id', 'id');
	}

	public function prline()
	{
		return $this->hasMany('PurchaseLine');
	}

}