<?php

namespace App\Models\Data;

class ProductCollection extends Eloquent {

	protected $table = 'product_collections';
	public $timestamps = true;
	protected $fillable = array('description', 'status');

	public function brand()
	{
		return $this->belongsTo('Brand', 'brand_id', 'id');
	}

	public function product()
	{
		return $this->hasMany('Product');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id', 'id');
	}

}