<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCollectionsTable extends Migration {

	public function up()
	{
		Schema::create('product_collections', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->text('description');
			$table->enum('status', array('Active', 'Inactive'));
			$table->integer('created_by')->default('0');
			$table->integer('updated_by')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_collections');
	}
}