<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateThreadTable extends Migration {

	public function up()
	{
		Schema::create('thread', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('initiated_by')->nullable();
			$table->enum('source', array('hire', 'direct'))->nullable();
			$table->string('last_message')->nullable();
			$table->integer('initiator_read_flag')->nullable();
			$table->integer('user_read_flag')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('thread');
	}
}