<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'company';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'address_en', 'address_ar', 'latitude', 'longitude', 'phone', 'email', 'whatsapp', 'facebook', 'twitter', 'instagram', 'snapchat');

    public function cities()
    {
        return $this->belongsToMany('City', 'company_city', 'company_id', 'city_id');
    }

}