<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CouponHistory extends Model 
{

    protected $table = 'coupon_history';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('coupon_id', 'user_id');

    public function coupon()
    {
        return $this->belongsTo('Coupon', 'coupon_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}