<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = false;
    protected $fillable = array('city_id', 'status', 'max_uses', 'uses', 'card_id', 'card_index');

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function card()
    {
        return $this->belongsTo('Card', 'card_id');
    }

}