<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('invoice_total');
			$table->string('original_filename', 255);
			$table->string('filename', 255);
			$table->string('invoice_type', 255)->nullable();
			$table->integer('id_order')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}