<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->double('sub_total');
			$table->bigInteger('shipping_id')->unsigned();
			$table->integer('status')->default('0');
			$table->double('total');
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}