<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Account extends Model 
{

    protected $table = 'accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('vendor');

    public function institution()
    {
        return $this->belongsTo('App\User');
    }

    public function creator()
    {
        return $this->belongsTo('App\User');
    }

    public function updated()
    {
        return $this->belongsTo('App\User');
    }

}