<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Campaign extends Model 
{

    protected $table = 'campaigns';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'start_date', 'end_date');

    public function accounts()
    {
        return $this->belongsToMany('App\Account');
    }

}