<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lead extends Model 
{

    protected $table = 'leads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status');

    public function getHistory()
    {
        return $this->hasMany('App\History');
    }

    public function creator()
    {
        return $this->belongsTo('App\User');
    }

    public function sharedTo()
    {
        return $this->belongsToMany('App\User');
    }

}