<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password');
    protected $fillable = array('phone', 'metadata');
    protected $visible = array('phone');

    public function groups()
    {
        return $this->belongsToMany('Group');
    }

    public function institution()
    {
        return $this->hasManyThrough('App\User', 'App\Group');
    }

}