<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderDetailsTable extends Migration {

	public function up()
	{
		Schema::create('order_details', function(Blueprint $table) {
			$table->increments('order_details_id');
			$table->integer('order_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->string('product_name', 255);
			$table->string('product_price', 255);
			$table->integer('product_sales_quantity');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_details');
	}
}