<?php

namespace App\Model;

class UserModel extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;
	protected $fillable = array('f_name', 'm_name', 'l_name', 'password', 'phone', 'email', 'role_id');
	protected $visible = array('f_name', 'm_name', 'l_name', 'password', 'phone', 'email', 'role_id');

	public function orders()
	{
		return $this->hasMany('OrderModel');
	}

	public function role_id()
	{
		return $this->hasOne('App\Model\RoleModel', 'role_id');
	}

	public function adress()
	{
		return $this->hasMany('AddressModel', 'user_id');
	}

	public function Cart()
	{
		return $this->hasMany('Cartmodel', 'user_id');
	}

}