<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('order_id');
			$table->integer('customer_id')->unsigned()->index();
			$table->integer('shipping_id')->unsigned()->index();
			$table->integer('payment_id')->unsigned()->index();
			$table->integer('order_total');
			$table->enum('order_status', array('Pending', 'Completed'));
			$table->string('order_date', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}