<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('personnel', function(Blueprint $table) {
			$table->foreign('type_personnel_id')->references('id')->on('type_personnel')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('detenant_centre', function(Blueprint $table) {
			$table->foreign('personnel_id')->references('id')->on('personnel')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('detenant_centre', function(Blueprint $table) {
			$table->foreign('centre_id')->references('id')->on('centre')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('personnel', function(Blueprint $table) {
			$table->dropForeign('personnel_type_personnel_id_foreign');
		});
		Schema::table('detenant_centre', function(Blueprint $table) {
			$table->dropForeign('detenant_centre_personnel_id_foreign');
		});
		Schema::table('detenant_centre', function(Blueprint $table) {
			$table->dropForeign('detenant_centre_centre_id_foreign');
		});
	}
}