<?php

namespace App\Models;

class TicketReplay extends Eloquent {

	protected $table = 'ticket_replies';
	public $timestamps = true;
	protected $fillable = array('client_id', 'employee_id', 'ticket_id', 'text');

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function employee()
	{
		return $this->belongsTo('App\Models\Employee');
	}

	public function ticket()
	{
		return $this->belongsTo('App\Models\Ticket');
	}

}