<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldsTable extends Migration {

	public function up()
	{
		Schema::create('fields', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('section_id');
			$table->string('label', 225);
			$table->enum('field_type', array(''text'', ''number'', ''dropdown'', ''checkbox'', ''image''));
			$table->enum('required', array(''));
			$table->json('options');
			$table->integer('sort')->default('0');
			$table->boolean('show_in_filter')->default(false);
			$table->boolean('show_in_mobile');
			$table->boolean('show_in_table_header')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fields');
	}
}