<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('number');
			$table->string('address');
			$table->bigInteger('payment_method_id')->unsigned();
			$table->string('status');
			$table->text('notes');
			$table->decimal('commission');
			$table->decimal('price');
			$table->integer('delivery_fee');
			$table->decimal('total_amount');
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('restaurant_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}