<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderPaymentsTable extends Migration {

	public function up()
	{
		Schema::create('order_payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->decimal('amount', 10,2);
			$table->date('date_paid');
			$table->enum('pay_method', array('foo', 'bar'));
			$table->string('reference');
			$table->date('date_deposited');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_payments');
	}
}