<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchasesTable extends Migration {

	public function up()
	{
		Schema::create('purchases', function(Blueprint $table) {
			$table->increments('id');
			$table->date('date_purchased');
			$table->integer('vendor_id')->unsigned();
			$table->decimal('total', 10,2);
			$table->decimal('freight_handling', 10,2);
			$table->decimal('tobacco_tax', 10,2);
			$table->decimal('non_inventory', 10,2);
			$table->string('shipped_via');
			$table->string('terms');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('purchases');
	}
}