<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorProductTable extends Migration {

	public function up()
	{
		Schema::create('vendor_product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_unit_id')->unsigned();
			$table->integer('vendor_id')->unsigned();
			$table->boolean('tobacco_tax')->default(0);
			$table->string('name');
			$table->string('location')->nullable();
			$table->string('model')->nullable();
			$table->decimal('cost', 16,8);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendor_product');
	}
}