<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $guarded = array('password');
	protected $fillable = array('email', 'role', 'first_name', 'last_name', 'phone');

	public function vehicles()
	{
		return $this->hasMany('Vehicle');
	}

	public function trips()
	{
		return $this->hasMany('Trip');
	}

	public function bookings()
	{
		return $this->hasMany('Booking');
	}

}