<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('author')->unsigned();
			$table->boolean('comment');
			$table->date('date');
			$table->text('content');
			$table->date('date_release')->nullable();
			$table->string('title');
			$table->string('video_link');
			$table->string('image_link');
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}