<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('artists', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('tr_jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('media_type_id')->references('id')->on('tr_media_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('cd_type_id')->references('id')->on('tr_cd_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('TA_artist_media', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('tr_role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('TA_artist_media', function(Blueprint $table) {
			$table->foreign('artist_id')->references('id')->on('artists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('TA_artist_media', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mp3', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fan_cover', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fan_comment', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fan_comment', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fan_comment', function(Blueprint $table) {
			$table->foreign('news_id')->references('id')->on('news')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('author')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fan_rate', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('artists', function(Blueprint $table) {
			$table->dropForeign('artists_job_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_media_type_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_cd_type_id_foreign');
		});
		Schema::table('TA_artist_media', function(Blueprint $table) {
			$table->dropForeign('TA_artist_media_role_id_foreign');
		});
		Schema::table('TA_artist_media', function(Blueprint $table) {
			$table->dropForeign('TA_artist_media_artist_id_foreign');
		});
		Schema::table('TA_artist_media', function(Blueprint $table) {
			$table->dropForeign('TA_artist_media_media_id_foreign');
		});
		Schema::table('mp3', function(Blueprint $table) {
			$table->dropForeign('mp3_media_id_foreign');
		});
		Schema::table('fan_cover', function(Blueprint $table) {
			$table->dropForeign('fan_cover_media_id_foreign');
		});
		Schema::table('fan_comment', function(Blueprint $table) {
			$table->dropForeign('fan_comment_author_id_foreign');
		});
		Schema::table('fan_comment', function(Blueprint $table) {
			$table->dropForeign('fan_comment_media_id_foreign');
		});
		Schema::table('fan_comment', function(Blueprint $table) {
			$table->dropForeign('fan_comment_news_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_author_foreign');
		});
		Schema::table('fan_rate', function(Blueprint $table) {
			$table->dropForeign('fan_rate_media_id_foreign');
		});
	}
}