<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVacationsTable extends Migration {

	public function up()
	{
		Schema::create('vacations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('annual_leaves_count')->nullable();
			$table->integer('sick_count')->nullable();
			$table->integer('non_paid_count')->nullable();
			$table->integer('request_before_days')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vacations');
	}
}