<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGalleriesTable extends Migration {

	public function up()
	{
		Schema::create('galleries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->bigInteger('governorate_id')->unsigned();
			$table->string('address')->nullable();
			$table->string('details')->nullable();
			$table->string('distance')->nullable();
			$table->string('phone')->nullable();
			$table->double('longitude')->default('0');
			$table->double('latitude')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('galleries');
	}
}