<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->string('name', 200)->nullable();
			$table->string('national_id', 100)->nullable();
			$table->bigInteger('governorate_id')->unsigned();
			$table->bigInteger('city_id')->unsigned();
			$table->string('address', 200)->nullable();
			$table->string('code', 20)->nullable();
			$table->string('confirmation_code')->nullable();
			$table->enum('phone_code', array('+20'));
			$table->string('phone', 50)->nullable();
			$table->double('longitude')->default('0');
			$table->double('latitude')->default('0');
			$table->enum('is_blocked', array('blocked', 'not_blocked'));
			$table->enum('is_login', array('online', 'offline'));
			$table->string('logo')->nullable();
			$table->enum('software_type', array('ios', 'android', 'web'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}