<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVideoGalleryTable extends Migration {

	public function up()
	{
		Schema::create('video_gallery', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('slug', 191)->unique();
			$table->tinyInteger('home_page')->nullable();
			$table->integer('created_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('video_gallery');
	}
}