<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSportsPagesTable extends Migration {

	public function up()
	{
		Schema::create('sports_pages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('activities_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 16)->nullable();
			$table->string('about', 1000)->nullable();
			$table->string('phone', 16)->nullable();
			$table->string('type', 32)->nullable();
			$table->string('address', 64)->nullable();
			$table->boolean('published');
			$table->integer('hits_no')->nullable();
			$table->integer('promos_no')->nullable();
			$table->string('image_0', 32)->nullable();
			$table->string('image_1', 32)->nullable();
			$table->string('image_3', 32)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sports_pages');
	}
}