<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('sports_page_id')->references('id')->on('sports_pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sports_pages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sports_pages', function(Blueprint $table) {
			$table->foreign('activities_id')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('sports_page_id')->references('id')->on('sports_pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_sports_page_id_foreign');
		});
		Schema::table('sports_pages', function(Blueprint $table) {
			$table->dropForeign('sports_pages_user_id_foreign');
		});
		Schema::table('sports_pages', function(Blueprint $table) {
			$table->dropForeign('sports_pages_activities_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_sports_page_id_foreign');
		});
	}
}