<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone', 'password', 'type');

	public function sportPage()
	{
		return $this->belongsTo('App/Models\User', 'user_id');
	}

	public function sportPage()
	{
		return $this->hasMany('App/Models\User', 'user_id');
	}

}