<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Trainer', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('restaurant', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('gyms', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('nutritionists', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('bank_informations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('availabilities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_subscriptions', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('coupon_subscriptions', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('coupon_subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('coupon_usages', function(Blueprint $table) {
			$table->foreign('coupon_subscription_id')->references('id')->on('coupon_subscriptions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Trainer', function(Blueprint $table) {
			$table->dropForeign('Trainer_user_id_foreign');
		});
		Schema::table('restaurant', function(Blueprint $table) {
			$table->dropForeign('restaurant_user_id_foreign');
		});
		Schema::table('gyms', function(Blueprint $table) {
			$table->dropForeign('gyms_user_id_foreign');
		});
		Schema::table('nutritionists', function(Blueprint $table) {
			$table->dropForeign('nutritionists_user_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_user_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_user_id_foreign');
		});
		Schema::table('bank_informations', function(Blueprint $table) {
			$table->dropForeign('bank_informations_user_id_foreign');
		});
		Schema::table('availabilities', function(Blueprint $table) {
			$table->dropForeign('availabilities_user_id_foreign');
		});
		Schema::table('package_subscriptions', function(Blueprint $table) {
			$table->dropForeign('package_subscriptions_package_id_foreign');
		});
		Schema::table('package_subscriptions', function(Blueprint $table) {
			$table->dropForeign('package_subscriptions_user_id_foreign');
		});
		Schema::table('coupon_subscriptions', function(Blueprint $table) {
			$table->dropForeign('coupon_subscriptions_coupon_id_foreign');
		});
		Schema::table('coupon_subscriptions', function(Blueprint $table) {
			$table->dropForeign('coupon_subscriptions_user_id_foreign');
		});
		Schema::table('coupon_usages', function(Blueprint $table) {
			$table->dropForeign('coupon_usages_coupon_subscription_id_foreign');
		});
	}
}