<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('given_name', 32);
			$table->string('last_name', 32);
			$table->string('google_id')->unique();
			$table->string('email', 128)->unique();
			$table->string('username', 32)->unique();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}