<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Dressings extends Eloquent {

	protected $table = 'dressings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'items_id');

	public function recipes()
	{
		return $this->hasManyThrough('App\Recipes', 'App\RecipeDressings', 'recipe_id', 'id', 'id', 'dressings_id');
	}

	public function items()
	{
		return $this->belongsTo('App\Items', 'id', 'items_id');
	}

}