<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sources', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('source_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('sources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rss_contents', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('twitter_contents', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('twitter_keywords')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('twitter_contents', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('twitter_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('twitter_accounts', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('twitter_keywords_occurences', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('id')->on('twitter_keywords')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flux_groups', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sources', function(Blueprint $table) {
			$table->dropForeign('sources_category_id_foreign');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->dropForeign('sources_media_id_foreign');
		});
		Schema::table('rss_contents', function(Blueprint $table) {
			$table->dropForeign('rss_contents_source_id_foreign');
		});
		Schema::table('twitter_contents', function(Blueprint $table) {
			$table->dropForeign('twitter_contents_keyword_id_foreign');
		});
		Schema::table('twitter_contents', function(Blueprint $table) {
			$table->dropForeign('twitter_contents_account_id_foreign');
		});
		Schema::table('twitter_accounts', function(Blueprint $table) {
			$table->dropForeign('twitter_accounts_source_id_foreign');
		});
		Schema::table('twitter_keywords_occurences', function(Blueprint $table) {
			$table->dropForeign('twitter_keywords_occurences_keyword_id_foreign');
		});
		Schema::table('flux_groups', function(Blueprint $table) {
			$table->dropForeign('flux_groups_image_id_foreign');
		});
	}
}