<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TwitterAccount extends Model 
{

    protected $table = 'twitter_accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contents()
    {
        return $this->hasMany('TwitterContent');
    }

    public function source()
    {
        return $this->belongsTo('Source');
    }

}