<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaterialsTable extends Migration {

	public function up()
	{
		Schema::create('materials', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->text('description');
			$table->bigInteger('category_id')->unsigned();
			$table->string('path');
			$table->string('cover_path');
			$table->text('abstract');
			$table->string('keywords');
			$table->bigInteger('downloads');
			$table->bigInteger('reads');
			$table->date('date');
			$table->string('isbn');
		});
	}

	public function down()
	{
		Schema::drop('materials');
	}
}