<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmpleadosTable extends Migration {

	public function up()
	{
		Schema::create('empleados', function(Blueprint $table) {
			$table->increments('id');
			$table->smallInteger('empresa_id');
			$table->smallInteger('no_empleado');
			$table->timestamps();
			$table->smallInteger('area_id');
			$table->smallInteger('puesto_id');
			$table->date('fecha_ingreso');
			$table->smallInteger('departamento_id');
			$table->char('apellido_paterno', 40);
			$table->char('apellido_materno', 40);
			$table->char('nombre', 40);
			$table->decimal('sueldo_base_mensual');
			$table->smallInteger('moneda_id');
			$table->char('no_cuenta', 20);
			$table->char('num_tarjeta_o_cta_clabe', 20);
			$table->smallInteger('banco_id');
			$table->char('correo_electronico', 50);
			$table->char('estatus_id', 2);
			$table->date('fecha_baja');
			$table->decimal('descto_faltas');
		});
	}

	public function down()
	{
		Schema::drop('empleados');
	}
}