<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('institution_id');
			$table->integer('role_id')->default('5');
			$table->string('name', 60);
			$table->string('first_name', 60);
			$table->string('username', 60);
			$table->string('email', 60);
			$table->string('password', 255);
			$table->date('date_of_birth');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}