<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIssuesTable extends Migration {

	public function up()
	{
		Schema::create('issues', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->text('issue_name');
			$table->string('severity', 255);
			$table->string('category', 255);
			$table->string('priority', 255);
			$table->string('platform', 255);
			$table->text('description');
			$table->string('status', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('issues');
	}
}