<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('issues', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_issue', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_issue', function(Blueprint $table) {
			$table->foreign('issue_id')->references('id')->on('issues')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('issues', function(Blueprint $table) {
			$table->dropForeign('issues_project_id_foreign');
		});
		Schema::table('user_issue', function(Blueprint $table) {
			$table->dropForeign('user_issue_user_id_foreign');
		});
		Schema::table('user_issue', function(Blueprint $table) {
			$table->dropForeign('user_issue_issue_id_foreign');
		});
	}
}