<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCertificationsTable extends Migration {

	public function up()
	{
		Schema::create('certifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('titre', 255);
			$table->string('codeCertif', 255);
			$table->enum('fee', array('payant', 'gratuit', 'remboursé'));
			$table->string('epreuve_duration');
			$table->integer('category_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('certifications');
	}
}